##############################################################################
#
#  			Copyright 2003 MPIMG Berlin, Germany.
#			      All Rights Reserved
#
#
#  System        : 
#  Module        : 
#  Object Name   : $RCSfile$
#  Revision      : $Revision$
#  Date          : $Date$
#  Author        : $Author$
#  Created By    : Dr. Detlef Groth
#  Created       : Mon Mar 10 16:41:10 2003
#  Last Modified : <030925.1038>
#
#  Description	
#
#  Notes
#
#  History
#	
#  $Log$
#
##############################################################################
#
#  Copyright (c) 2003 MPIMG Berlin, Germany.
# 
#  All Rights Reserved.
# 
#  This  document  may  not, in  whole  or in  part, be  copied,  photocopied,
#  reproduced,  translated,  or  reduced to any  electronic  medium or machine
#  readable form without prior written consent from MPIMG Berlin, Germany.
#
##############################################################################
package provide app-dgODBC2CSV 1.0
package require tclodbc 
package require cmdline
proc main {database sep ext} {
    set var(sep) $sep
    foreach db $database {
        database connect db $db
        foreach table [DataBase:GetTables] {
            puts -nonewline "fetching tabledata $table from $db"
            set ok " with ERROR!"
            catch { 
                
                db statement s "Select * from $table"
                s execute
                #puts -nonewline " s execute"
                set out [open $db.$table.$ext w 0600]
                puts -nonewline " and saving into $db.$table.$ext"
                set cols [DataBase:GetColumns $table]
                #puts -nonewline " cols"
                #regsub -all " " $cols "\t" cols
                puts $out "[join $cols $sep]"
                while {[set row [s fetch]] != {}} {
                    #regsub -all " " $row "\t" row
                    set line "[join $row $sep]"
                    regsub "$sep$" $line "$var(sep)NULL" line
                    regsub -all "$var(sep)$var(sep)" $line "$var(sep)NULL$var(sep)" line
                    puts $out "$line"
                }
                
                close $out
                set ok "was OK!"
            } 
            puts " $ok"
        }
        db disconnect
    }
}
proc DataBase:GetColumns {table} {
    set data [db columns $table]
    set cols {}
    foreach col $data {
        lappend cols [lindex $col 3]
    }
    return $cols
}
proc DataBase:GetTables {} {
    set x 0
    set tables {}
    foreach  tab [db tables] {
        if {[lindex $tab 3] eq "SYSTEM TABLE"} {
            continue
        }
        set tabelle [lindex $tab 2]
        if {![string match {*$} $tabelle]} {
            lappend tables $tabelle
        }
        
    }
    return $tables
    
}
proc usage {} {
    puts "Usage: dgODBC2TAB ?-sep sepchar(tab|comma|semikolon|space)? ?-help? database1 database2 ...."
    puts "Databases are: "
    foreach item [database datasources] {
        puts "[lindex $item 0]\tDriver: [lindex $item 1]"
    }
    exit
}
if {[llength $argv] > 0} {
    set sepChar ,
    set ext csv
    while {[set ok [cmdline::getopt argv {sep.arg help} opt val]] > 0} {
        #puts stderr "= $opt $val"
        switch -exact -- $opt {
            sep  {set sepChar $val}
            help { usage }
        }
        switch -exact -- $sepChar {
            tab {
                set sepChar  "\t"
                set ext tab
            }
            semikolon {
                set sepChar  ";"
            }
            pipe {
                set sepChar  "|"
            }
            space {
                set sepChar  " "
                set ext dat
            } 
            default {
                set sepChar ","
            }
            
        }
       
            
        
    }
    main $argv $sepChar $ext
} else {
    usage
}
